#include <mail/catdog/cpp/lib/destinations.h>
#include <map>


namespace cpp {

const std::map<const std::string, Destination> convertStrToDestination = {
    { "bb", Destination::bb },
    { "bb_corp", Destination::bb_corp },
    { "ava", Destination::ava }
};


Destination makeDestinationByName(const std::string& name) {
    return convertStrToDestination.at(name);
}

}
