#include <mail/catdog/cpp/lib/palette.h>
#include <fstream>
#include <string>
#include <vector>
#include <boost/algorithm/string.hpp>


namespace cpp {

std::vector<std::string> palette;

const std::vector<std::string>& getPalette() {
    return palette;
}


void setPalette(std::vector<std::string> paletteValue) {
    palette = std::move(paletteValue);
}


void loadPalette(const std::string& palettePath) {
    std::ifstream fin(palettePath);

    std::vector<std::string> palette;
    std::string buffer;
    while(std::getline(fin, buffer)) {
        boost::trim(buffer);
        palette.push_back(buffer);
    }

    fin.close();
    setPalette(std::move(palette));
}

}
