#include <mail/catdog/cpp/lib/utils.h>

namespace cpp {

boost::python::dict toPythonDict(const std::map<std::string, std::string> &map) {
    boost::python::dict dictionary;
    for (const auto &[key, value] : map) {
        dictionary[key] = value;
    }
    return dictionary;
}


boost::python::dict toPythonDict(const std::map<std::string, std::optional<std::string>>& map) {
    boost::python::dict dictionary;
    for (const auto &[key, value] : map) {
        dictionary[key] = (value) ? boost::python::str(*value) : boost::python::object();  
    }

    return dictionary;
}


std::map<std::string, std::optional<std::string>> convertDictToMap(boost::python::dict pyDict) {
    std::map<std::string, std::optional<std::string>> resultMap;

    boost::python::list keys = pyDict.keys();
    for (int i = 0; i < len(keys); i++) {
        std::string key = boost::python::extract<std::string>(keys[i]);
        std::optional<std::string> value;
        if (pyDict[key]) {
            value = std::make_optional<std::string>(boost::python::extract<std::string>(pyDict[key]));
        }

        resultMap[std::move(key)] = std::move(value);
    }

    return resultMap;
}


std::vector<std::string> toVector(boost::python::list pyList) {
    std::vector<std::string> resultVector;
    for (int i = 0; i < boost::python::len(pyList); i++) {
        resultVector.push_back(boost::python::extract<std::string>(pyList[i]));
    }

    return resultVector;
}

}
