#!/usr/bin/env python3

import ast
import argparse
import json
import string
import sys


def parse_line(line):
    result = {}
    for pair in line.split('\t'):
        values = pair.split('=')
        if (len(values) == 2):
            result[values[0]] = values[1]
    return result


def noise_body(body):
    in_triangular_brackets = False
    after_at = False
    result = ""
    for ch in body:
        if ch == '<':
            in_triangular_brackets = True
            after_at = False
        elif ch == '>':
            in_triangular_brackets = False
            after_at = False
        elif ch == '@':
            if in_triangular_brackets:
                after_at = True
        elif ch.isalnum() and not in_triangular_brackets:
            ch = 'a'
        result += ch
    return result


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', '-i', action='store', dest='input', help='input log')
    parser.add_argument('--output', '-o', action='store', dest='output', help='output file')
    args = parser.parse_args()
    with open(args.input, "r") as file_input, open(args.output, "w") as file_output:
        for log_line in file_input:
            log_line = log_line.replace(r"\\'", "")
            line_map = parse_line(log_line[:-1])
            if ('reason' in line_map) and (
                    line_map['reason'] == 'handle_emails') and ('body' in line_map):
                body = line_map['body']

                users = ast.literal_eval(noise_body(body))
                json.dump(users, file_output, ensure_ascii=False)
                file_output.write('\n')


if __name__ == '__main__':
    main()
