package ru.yandex.mail.cerberus.asyncdb;

import lombok.AccessLevel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

import static java.util.Collections.emptyMap;

public class Condition {
    private static final Condition EMPTY = new Condition("", emptyMap());

    @Getter(AccessLevel.PACKAGE) private final String sql;
    @Getter(AccessLevel.PACKAGE) private final Map<String, Object> bindings;

    Condition(String sql, Map<String, Object> bindings) {
        this.sql = sql;
        this.bindings = bindings;
    }

    public static Condition empty() {
        return EMPTY;
    }

    public static Condition of(String sql) {
        return new Condition(sql, new HashMap<>());
    }

    public <T> Condition bind(String name, T value) {
        bindings.put(name, value);
        return this;
    }
}
