package ru.yandex.mail.cerberus.asyncdb;

import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import ru.yandex.mail.cerberus.asyncdb.annotations.BindId;
import ru.yandex.mail.cerberus.asyncdb.annotations.BindIdList;

import java.util.List;
import java.util.Optional;

public interface CrudRepository<ID, E> extends RoCrudRepository<ID, E> {
    @GetGeneratedKeys
    @SqlUpdate('<' + Alias.INSERTION_QUERY + '>')
    E insert(@BindBean E entity);

    @GetGeneratedKeys
    @SqlBatch('<' + Alias.INSERTION_QUERY + '>')
    List<E> insertAll(@BindBean Iterable<E> entities);

    @SqlQuery('<' + Alias.UPDATING_QUERY + '>')
    Optional<E> update(@BindBean E entity);

    @GetGeneratedKeys
    @SqlBatch('<' + Alias.UPDATING_QUERY + '>')
    List<E> updateAll(@BindBean Iterable<E> entities);

    @SqlUpdate("DELETE FROM <table> WHERE (<id>) = (<idBindings>)")
    boolean delete(@BindId ID id);

    @GetGeneratedKeys
    @SqlQuery("DELETE FROM <table>\n"
            + "WHERE (<id>) IN (<ids>)\n"
            + "RETURNING <id>")
    List<ID> deleteAll(@BindIdList Iterable<ID> ids);

    @GetGeneratedKeys
    @SqlQuery("DELETE FROM <table>\n"
            + "RETURNING <id>")
    List<ID> deleteAll();
}
