package ru.yandex.mail.cerberus.asyncdb.annotations;

import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import ru.yandex.mail.cerberus.asyncdb.internal.CrudRepositoryConfigurer;
import ru.yandex.mail.cerberus.asyncdb.internal.CrudRepositoryStatementCustomizer;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(CrudRepositoryStatementCustomizer.class)
@ConfiguringAnnotation(CrudRepositoryConfigurer.class)
public @interface ConfigureCrudRepository {
    String table();
}
