package ru.yandex.mail.cerberus.asyncdb.internal;

import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import ru.yandex.mail.cerberus.asyncdb.annotations.AsString;

import java.lang.reflect.Type;
import java.sql.Types;
import java.util.Optional;

@AsString
public class AsStringArgumentFactory implements ArgumentFactory {
    private Argument createArgument(Object value) {
        if (value == null) {
            return (position, statement, ctx) -> statement.setNull(position, Types.OTHER);
        } else {
            return (position, statement, ctx) -> statement.setString(position, value.toString());
        }
    }

    @Override
    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        return Optional.of(createArgument(value));
    }
}
