package ru.yandex.mail.cerberus.asyncdb.internal;

import lombok.Lombok;
import lombok.val;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import ru.yandex.mail.cerberus.asyncdb.annotations.AsString;

import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Optional;

@AsString
public class AsStringColumnMapperFactory implements ColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        val clazz = GenericTypes.getErasedType(type);
        val constructor = MethodHandleUtils.findConstructor(clazz, String.class)
            .orElseThrow(() -> new IllegalArgumentException("Invalid @AsString usage, class '" + clazz +
                "' needs to have single String argument public constructor"));

        return Optional.of((resultSet, columnNumber, ctx) -> {
            try {
                val value = resultSet.getString(columnNumber);

                if (value == null) {
                    return null;
                }

                return constructor.invoke(value);
            } catch (SQLException e) {
                throw e;
            } catch (Throwable e) {
                throw Lombok.sneakyThrow(e);
            }
        });
    }
}
