package ru.yandex.mail.cerberus.asyncdb.internal;

import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

public class BindIdFactory implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method,
                                                              Parameter param, int index, Type paramType) {
        if (sqlObjectType.isAnnotationPresent(CompositeId.class)) {
            return SqlStatement::bindBean;
        } else {
            return (stmt, arg) -> {
                stmt.bind("id", arg);
            };
        }
    }
}
