package ru.yandex.mail.cerberus.asyncdb.internal;

import lombok.val;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import ru.yandex.mail.cerberus.asyncdb.SortOrder;
import ru.yandex.mail.cerberus.asyncdb.annotations.BindBeans;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

public class BindIdListFactory implements SqlStatementCustomizerFactory {
    private static final BindBeansFactory FACTORY = new BindBeansFactory();
    private static final Annotation BIND_BEANS = new BindBeans() {
        @Override
        public Class<? extends Annotation> annotationType() {
            return BindBeans.class;
        }

        @Override
        public SortOrder propertiesOrder() {
            return SortOrder.ASC;
        }
    };

    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method,
                                                              Parameter param, int index, Type paramType) {
        if (sqlObjectType.isAnnotationPresent(CompositeId.class)) {
            return FACTORY.createForParameter(BIND_BEANS, sqlObjectType, method, param, index, paramType);
        } else {
            val name = param.getName();
            return (stmt, arg) -> stmt.bindList(name, IterableLike.toList(arg));
        }
    }
}
