package ru.yandex.mail.cerberus.asyncdb.internal;

import lombok.val;
import one.util.streamex.IntStreamEx;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;

public class BindValuesFactory implements SqlStatementCustomizerFactory {
    private static void bindValues(String argName, List<?> values, SqlStatement<?> statement) {
        val parser = statement.getConfig().get(SqlStatements.class).getSqlParser();
        val context = statement.getContext();

        val namesListString = IntStreamEx.range(0, values.size())
            .mapToEntry(i -> i, i -> argName + i)
            .peekKeyValue((index, name) -> statement.bind(name, values.get(index)))
            .values()
            .map(name -> '(' + parser.nameParameter(name, context) + ')')
            .joining(", ");

        statement.define(argName, namesListString);
    }

    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method,
                                                              Parameter param, int index, Type paramType) {
        final String name = ParameterUtil.findParameterName("", param)
            .orElseThrow(() -> new UnsupportedOperationException("A @BindValues parameter was not given a name, "
                + "and parameter name data is not present in the class file, for: "
                + param.getDeclaringExecutable() + "::" + param));

        return (stmt, arg) -> {
            if (arg == null) {
                throw new IllegalArgumentException("@BindValues doesn't support null collections");
            } else {
                val list = IterableLike.toList(arg);
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("@BindValues doesn't support empty collection");
                }
                bindValues(name, list, stmt);
            }
        };
    }
}
