package ru.yandex.mail.cerberus.asyncdb.internal;

import lombok.experimental.UtilityClass;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;

@UtilityClass
public class MethodHandleUtils {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();

    public static Optional<MethodHandle> findConstructor(Class<?> cls, Class<?> parameterClass) {
        try {
            return Optional.of(lookup.findConstructor(cls, MethodType.methodType(void.class, parameterClass)));
        } catch (NoSuchMethodException | IllegalAccessException e) {
            return Optional.empty();
        }
    }
}
