package ru.yandex.mail.cerberus.asyncdb.internal;

import lombok.experimental.UtilityClass;
import ru.yandex.mail.cerberus.asyncdb.CrudRepository;
import ru.yandex.mail.cerberus.asyncdb.RoCrudRepository;
import ru.yandex.mail.cerberus.asyncdb.exception.CrudRepositoryConfigurationException;

import java.lang.reflect.Type;

import static org.jdbi.v3.core.generic.GenericTypes.findGenericParameter;

@UtilityClass
class RepositoryInfoUtils {
    private static final int ID_GENERIC_TYPE_INDEX = 0;
    private static final int ENTITY_GENERIC_TYPE_INDEX = 1;

    private static Type findGenericType(Class<?> repositoryType, int index) {
        return findGenericParameter(repositoryType, CrudRepository.class, index)
            .or(() -> findGenericParameter(repositoryType, RoCrudRepository.class, index))
            .orElseThrow(() -> new CrudRepositoryConfigurationException(repositoryType));
    }

    static Type findEntityType(Class<?> repositoryType) {
        return findGenericType(repositoryType, ENTITY_GENERIC_TYPE_INDEX);
    }

    static Type findIdType(Class<?> repositoryType) {
        return findGenericType(repositoryType, ID_GENERIC_TYPE_INDEX);
    }
}
