package ru.yandex.mail.cerberus.asyncdb.internal.value;

import lombok.val;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import java.lang.reflect.Type;
import java.sql.Types;
import java.util.Optional;

public class LongValueTypeArgumentFactory implements ArgumentFactory {
    @Override
    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        val valueClass = GenericTypes.getErasedType(type);
        if (LongValueType.class.isAssignableFrom(valueClass)) {
            val valueObject = (LongValueType) value;

            return Optional.of((position, statement, ctx) -> {
                if (valueObject == null) {
                    statement.setNull(position, Types.BIGINT);
                } else {
                    statement.setLong(position, valueObject.getValue());
                }
            });
        } else {
            return Optional.empty();
        }
    }
}
