package ru.yandex.mail.cerberus.asyncdb.internal.value;

import lombok.Lombok;
import lombok.val;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import ru.yandex.mail.cerberus.asyncdb.internal.MethodHandleUtils;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import java.lang.reflect.Type;
import java.util.Optional;

public class LongValueTypeColumnMapperFactory implements ColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        val valueClass = GenericTypes.getErasedType(type);
        if (LongValueType.class.isAssignableFrom(valueClass)) {
            val constructor = MethodHandleUtils.findConstructor(valueClass, long.class)
                    .orElseThrow(() -> new IllegalArgumentException("Class " + valueClass + " needs to have `(long)` constructor"));

            return Optional.of((resultSet, columnNumber, ctx) -> {
                try {
                    val longValue = resultSet.getLong(columnNumber);
                    return resultSet.wasNull() ? null : constructor.invoke(longValue);
                } catch (Throwable e) {
                    throw Lombok.sneakyThrow(e);
                }
            });
        } else {
            return Optional.empty();
        }
    }
}
