package ru.yandex.mail.cerberus.asyncdb.internal.value;

import lombok.val;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypeFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import java.lang.reflect.Type;
import java.util.Optional;

public class LongValueTypeSqlArrayTypeFactory implements SqlArrayTypeFactory {
    @Override
    public Optional<SqlArrayType<?>> build(Type elementType, ConfigRegistry config) {
        val elementClass = GenericTypes.getErasedType(elementType);
        if (LongValueType.class.isAssignableFrom(elementClass)) {
            return Optional.of(new SqlArrayType<>() {
                @Override
                public String getTypeName() {
                    return "BIGINT";
                }

                @Override
                public Object convertArrayElement(Object element) {
                    val longValueElement = (LongValueType) element;
                    return (element == null) ? null : longValueElement.getValue();
                }
            });
        } else {
            return Optional.empty();
        }
    }
}
