package ru.yandex.mail.cerberus.asyncdb.internal.value;

import lombok.val;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import ru.yandex.mail.micronaut.common.value.ValueType;

import java.lang.reflect.Type;
import java.util.Optional;

import static org.jdbi.v3.core.generic.GenericTypes.findGenericParameter;

public class ValueTypeArgumentFactory implements ArgumentFactory {
    @Override
    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        val valueClass = GenericTypes.getErasedType(type);
        if (ValueType.class.isAssignableFrom(valueClass)) {
            val wrappedValueType = findGenericParameter(type, ValueType.class, 0)
                    .orElseThrow(() -> new IllegalArgumentException("ValueType is not parameterized for class " + valueClass));
            val valueObject = (ValueType) value;
            val wrappedValue = (value == null) ? null : valueObject.getValue();
            return config.get(Arguments.class).findFor(wrappedValueType, wrappedValue);
        } else {
            return Optional.empty();
        }
    }
}
