package ru.yandex.mail.cerberus.asyncdb.internal.value;

import lombok.Lombok;
import lombok.val;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import ru.yandex.mail.cerberus.asyncdb.internal.MethodHandleUtils;
import ru.yandex.mail.micronaut.common.value.ValueType;

import java.lang.reflect.Type;
import java.util.Optional;

import static org.jdbi.v3.core.generic.GenericTypes.findGenericParameter;

public class ValueTypeColumnMapperFactory implements ColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        val valueClass = GenericTypes.getErasedType(type);
        if (ValueType.class.isAssignableFrom(valueClass)) {
            val wrappedValueType = findGenericParameter(type, ValueType.class, 0)
                    .orElseThrow(() -> new IllegalArgumentException("ValueType is not parameterized for class " + valueClass));
            val wrappedValueClass = (Class) wrappedValueType;
            val constructor = MethodHandleUtils.findConstructor(valueClass, wrappedValueClass)
                    .orElseThrow(() -> new IllegalArgumentException("Class " + valueClass + " needs to have `(Wrapped)` constructor"));
            val wrappedValueMapper = config.get(ColumnMappers.class).findFor(wrappedValueType)
                    .orElseThrow(() -> new IllegalArgumentException("Can't find mapper for " + wrappedValueClass));

            return Optional.of((resultSet, columnNumber, ctx) -> {
                try {
                    val wrappedValue = wrappedValueMapper.map(resultSet, columnNumber, ctx);
                    return (wrappedValue == null) ? null : constructor.invoke(wrappedValue);
                } catch (Throwable e) {
                    throw Lombok.sneakyThrow(e);
                }
            });
        } else {
            return Optional.empty();
        }
    }
}
