package ru.yandex.mail.cerberus.asyncdb.internal.value;

import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypeFactory;
import org.jdbi.v3.core.array.SqlArrayTypes;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import ru.yandex.mail.micronaut.common.value.ValueType;

import java.lang.reflect.Type;
import java.util.Optional;

public class ValueTypeSqlArrayTypeFactory implements SqlArrayTypeFactory {
    @Override
    public Optional<SqlArrayType<?>> build(Type elementType, ConfigRegistry config) {
        var elementClass = GenericTypes.getErasedType(elementType);
        if (ValueType.class.isAssignableFrom(elementClass)) {
            var wrappedElementType = GenericTypes.findGenericParameter(elementType, ValueType.class, 0)
                    .orElseThrow(() -> new IllegalArgumentException("ValueType is not parameterized for class " + elementClass));

            return config.get(SqlArrayTypes.class).findFor(wrappedElementType)
                    .map((SqlArrayType wrappedElementArrayType) -> {
                        return new SqlArrayType<Object>() {
                            @Override
                            public String getTypeName() {
                                return wrappedElementArrayType.getTypeName();
                            }

                            @Override
                            @SuppressWarnings("unchecked")
                            public Object convertArrayElement(Object element) {
                                if (element == null) {
                                    return null;
                                }

                                var valueTypeElement = (ValueType) element;
                                return wrappedElementArrayType.convertArrayElement(valueTypeElement.getValue());
                            }
                        };
                    });
        } else {
            return Optional.empty();
        }
    }
}
