package ru.yandex.mail.cerberus.asyncdb.util;

import lombok.AllArgsConstructor;
import lombok.Getter;
import one.util.streamex.EntryStream;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AllArgsConstructor
public class OneToMany<K, V> {
    @Getter private final Map<K, List<V>> mapping;

    public Map<K, Set<V>> getSetMapping() {
        return EntryStream.of(mapping)
            .mapValues(Set::copyOf)
            .toImmutableMap();
    }
}
