package ru.yandex.mail.cerberus.client;

import lombok.val;
import reactor.core.publisher.Flux;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.client.dto.Group;
import ru.yandex.mail.cerberus.client.ops.GroupOperations;
import ru.yandex.mail.micronaut.common.Async;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.micronaut.common.RawJsonString;
import ru.yandex.mail.micronaut.tvm.auth.TvmSecured;

import java.util.List;
import java.util.Optional;

@TvmSecured
@RegisterCerberusClient(path = "/group")
public interface GroupClient extends GroupOperations {
    default Flux<List<Group<RawJsonString>>> allGroupsRx(int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<GroupKey> pageable) -> {
            return allGroups(pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<Group<RawJsonString>>> allGroupsRx(int pageSize) {
        return allGroupsRx(pageSize, Optional.empty());
    }

    default Flux<List<Group<RawJsonString>>> findGroupsByTypeRx(GroupType type, int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<GroupId> pageable) -> {
            return findGroupsByType(type, pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<Group<RawJsonString>>> findGroupsByTypeRx(GroupType type, int pageSize) {
        return findGroupsByTypeRx(type, pageSize, Optional.empty());
    }
}
