package ru.yandex.mail.cerberus.client;

import lombok.val;
import reactor.core.publisher.Flux;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.LocationType;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.client.dto.Location;
import ru.yandex.mail.cerberus.client.ops.LocationOperations;
import ru.yandex.mail.micronaut.common.Async;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.micronaut.common.RawJsonString;
import ru.yandex.mail.micronaut.tvm.auth.TvmSecured;

import java.util.List;
import java.util.Optional;

@TvmSecured
@RegisterCerberusClient(path = "/location")
public interface LocationClient extends LocationOperations {
    default Flux<List<Location<RawJsonString>>> allLocationsRx(int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<LocationKey> pageable) -> {
            return allLocations(pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<Location<RawJsonString>>> allLocationsRx(int pageSize) {
        return allLocationsRx(pageSize, Optional.empty());
    }

    default Flux<List<Location<RawJsonString>>> findLocationsByTypeRx(LocationType type, int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<LocationId> pageable) -> {
            return findLocationsByType(type, pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<Location<RawJsonString>>> findLocationsByTypeRx(LocationType type, int pageSize) {
        return findLocationsByTypeRx(type, pageSize, Optional.empty());
    }
}
