package ru.yandex.mail.cerberus.client;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.validation.Validated;
import ru.yandex.mail.cerberus.client.dto.ErrorResult;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static ru.yandex.mail.cerberus.client.Constants.CLIENT_ID;

@Validated
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Header(name = "Accept-Encoding", value = "gzip, deflate")
@Client(id = CLIENT_ID, errorType = ErrorResult.class)
// TODO: use @Retryable(predicate=...) instead of @WithRetry after Micronaut 2.0 has been released
@WithRetry
@interface RegisterCerberusClient {
    @AliasFor(annotation = Client.class, member = "path")
    String path();
}
