package ru.yandex.mail.cerberus.client;

import lombok.val;
import reactor.core.publisher.Flux;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.client.dto.Resource;
import ru.yandex.mail.cerberus.client.ops.ResourceOperations;
import ru.yandex.mail.micronaut.common.Async;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.micronaut.common.RawJsonString;
import ru.yandex.mail.micronaut.tvm.auth.TvmSecured;

import java.util.List;
import java.util.Optional;

@TvmSecured
@RegisterCerberusClient(path = "/resource")
public interface ResourceClient extends ResourceOperations {
    default Flux<List<Resource<RawJsonString>>> findResourcesByTypeRx(ResourceTypeName type, int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<ResourceId> pageable) -> {
            return findResourcesByType(type, pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<Resource<RawJsonString>>> findResourcesByTypeRx(ResourceTypeName type, int pageSize) {
        return findResourcesByTypeRx(type, pageSize, Optional.empty());
    }
}
