package ru.yandex.mail.cerberus.client;

import lombok.val;
import reactor.core.publisher.Flux;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.UserType;
import ru.yandex.mail.cerberus.client.dto.User;
import ru.yandex.mail.cerberus.client.dto.UserWithGroups;
import ru.yandex.mail.cerberus.client.ops.UserOperations;
import ru.yandex.mail.micronaut.common.Async;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.micronaut.common.RawJsonString;
import ru.yandex.mail.micronaut.tvm.auth.TvmSecured;

import java.util.List;
import java.util.Optional;

@TvmSecured
@RegisterCerberusClient(path = "/user")
public interface UserClient extends UserOperations {
    default Flux<List<User<RawJsonString>>> usersRx(UserType type, int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<Uid> pageable) -> {
            return users(type, pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<User<RawJsonString>>> usersRx(UserType type, int pageSize) {
        return usersRx(type, pageSize, Optional.empty());
    }

    default Flux<List<UserWithGroups<RawJsonString>>> usersWithGroupsRx(UserType type, int pageSize, Optional<ReadTarget> readTarget) {
        val target = readTarget.orElse(null);
        return Async.fetchPagesRx(pageSize, (Pageable<Uid> pageable) -> {
            return usersWithGroups(type, pageable.getPageSize(), pageable.getPageId().orElse(null), target).toFuture();
        });
    }

    default Flux<List<UserWithGroups<RawJsonString>>> usersWithGroupsRx(UserType type, int pageSize) {
        return usersWithGroupsRx(type, pageSize, Optional.empty());
    }
}
