package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.experimental.Delegate;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.List;
import java.util.Set;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class AllowedActions {
    @Value
    @Introspected
    @AllArgsConstructor
    public static class ResourceInfo {
        @Delegate ResourceKey key;
        Set<String> actions;

        @JsonCreator
        public ResourceInfo(ResourceId id, ResourceTypeName type, Set<String> actions) {
            this(new ResourceKey(id, type), actions);
        }

        @JsonIgnore
        public ResourceKey getKey() {
            return key;
        }
    }

    List<ResourceInfo> resources;
}
