package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.List;
import java.util.Set;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class AllowedTypeActions {
    @Value
    @Introspected
    public static class ResourceTypeInfo {
        ResourceTypeName name;
        Set<String> actions;
    }

    List<ResourceTypeInfo> types;
}
