package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.Value;
import ru.yandex.mail.micronaut.common.CerberusUtils;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceTypeName;

import javax.validation.constraints.NotBlank;
import java.util.Optional;
import java.util.Set;

@Value
@Introspected
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Grant {
    Set<@NotBlank String> actions;
    ResourceTypeName resourceType;
    Optional<ResourceId> resourceId;

    @JsonCreator
    public Grant(Set<String> actions, ResourceTypeName resourceType, Optional<ResourceId> resourceId) {
        this.actions = actions;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
    }

    public <E extends Enum<E>> Grant(Class<E> actionsEnum, ResourceTypeName resourceType, Optional<ResourceId> resourceId) {
        this(CerberusUtils.nameSetOf(actionsEnum), resourceType, resourceId);
    }

    public <E extends Enum<E>> Grant(Class<E> actionsEnum, ResourceTypeName resourceType) {
        this(actionsEnum, resourceType, Optional.empty());
    }

    public <E extends Enum<E>> Grant(Class<E> actionsEnum, ResourceTypeName resourceType, ResourceId resourceId) {
        this(actionsEnum, resourceType, Optional.of(resourceId));
    }

    public Grant(Set<String> actions, ResourceTypeName resourceType, ResourceId resourceId) {
        this(actions, resourceType, Optional.of(resourceId));
    }

    public Grant(Set<String> actions, ResourceTypeName resourceType) {
        this(actions, resourceType, Optional.empty());
    }
}
