package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.experimental.Delegate;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;

import java.util.Optional;

@Value
@Introspected
@AllArgsConstructor
public class Group<T> {
    GroupId id;
    @Delegate GroupData<T> data;

    @JsonCreator
    public Group(GroupId id, GroupType type, String name, boolean active, Optional<T> info) {
        this(id, new GroupData<>(type, name, active, info));
    }

    public Group(GroupId id, GroupType type, String name, boolean active) {
        this(id, new GroupData<>(type, name, active));
    }

    public Group(GroupId id, GroupType type, String name, boolean active, T info) {
        this(id, new GroupData<>(type, name, active, info));
    }

    @JsonIgnore
    public GroupData<T> getData() {
        return data;
    }

    public GroupKey extractKey() {
        return new GroupKey(id, getType());
    }
}
