package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.GroupType;

import javax.validation.constraints.NotBlank;
import java.util.Optional;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class GroupData<T> {
    GroupType type;
    @NotBlank String name;
    boolean active;
    Optional<T> info;

    public GroupData(GroupType type, String name, boolean active) {
        this(type, name, active, Optional.empty());
    }

    public GroupData(GroupType type, String name, boolean active, T info) {
        this(type, name, active, Optional.of(info));
    }
}
