package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.experimental.Delegate;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.LocationType;

import java.util.Optional;

@Value
@Introspected
@AllArgsConstructor
public class Location<T> {
    LocationId id;
    @Delegate LocationData<T> data;

    @JsonCreator
    public Location(LocationId id, LocationType type, String name, Optional<T> info) {
        this(id, new LocationData<>(type, name, info));
    }

    @JsonIgnore
    public LocationData<T> getData() {
        return data;
    }

    public LocationKey extractKey() {
        return new LocationKey(id, getType());
    }
}
