package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.experimental.Delegate;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.Optional;

@Value
@Introspected
@AllArgsConstructor
public class Resource<T> {
    ResourceId id;
    @Delegate ResourceData<T> data;

    @JsonCreator
    public Resource(ResourceId id, ResourceTypeName type, String name, Optional<LocationKey> location, boolean active,
                    Optional<T> info) {
        this(id, new ResourceData<>(type, name, location, active, info));
    }

    public Resource(ResourceId id, ResourceType type, String name, Optional<LocationKey> location, boolean active, Optional<T> info) {
        this(id, new ResourceData<>(type.getName(), name, location, active, info));
    }

    @JsonIgnore
    public ResourceData<T> getData() {
        return data;
    }

    public ResourceKey extractKey() {
        return new ResourceKey(id, data.getType());
    }
}
