package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.ResourceTypeName;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Optional;

@With
@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class ResourceData<T> {
    @NotNull ResourceTypeName type;
    @NotBlank String name;
    Optional<LocationKey> location;
    boolean active;
    Optional<T> info;

    public ResourceData(ResourceTypeName type, String name, Optional<LocationKey> location, boolean active) {
        this(type, name, location, active, Optional.empty());
    }

    public ResourceData(ResourceTypeName type, String name, Optional<LocationKey> location, boolean active, T info) {
        this(type, name, location, active, Optional.of(info));
    }
}
