package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.CerberusUtils;
import ru.yandex.mail.cerberus.ResourceTypeName;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Optional;
import java.util.Set;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ResourceType {
    ResourceTypeName name;
    Optional<String> description;
    @NotEmpty Set<@NotBlank String> actionSet;

    public ResourceType(ResourceTypeName name, Set<String> actionSet) {
        this(name, Optional.empty(), actionSet);
    }

    public ResourceType(ResourceTypeName name, String description, Set<String> actionSet) {
        this(name, Optional.of(description), actionSet);
    }

    public <T extends Enum<T>> ResourceType(ResourceTypeName name, Class<T> actionSetEnum) {
        this(name, CerberusUtils.nameSetOf(actionSetEnum));
    }

    public <T extends Enum<T>> ResourceType(ResourceTypeName name, String description, Class<T> actionSetEnum) {
        this(name, description, CerberusUtils.nameSetOf(actionSetEnum));
    }
}
