package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.experimental.Delegate;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.RoleName;

import java.util.Optional;

@Value
@Introspected
@AllArgsConstructor
public class Role {
    RoleId id;
    @Delegate RoleData data;

    @JsonCreator
    public Role(RoleId id, RoleName name, Optional<String> description, boolean active) {
        this(id, new RoleData(name, description, active));
    }

    @JsonIgnore
    public RoleData getData() {
        return data;
    }
}
