package ru.yandex.mail.cerberus.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.UserType;

import javax.validation.constraints.NotBlank;
import java.util.Optional;

@With
@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class User<T> {
    Uid uid;
    UserType type;
    @NotBlank String login;
    Optional<T> info;

    public User(Uid uid, UserType type, String login) {
        this(uid, type, login, Optional.empty());
    }

    public User(Uid uid, UserType type, String login, T data) {
        this(uid, type, login, Optional.of(data));
    }
}
