package ru.yandex.mail.cerberus.client.ops;

import io.micronaut.cache.annotation.Cacheable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.Status;
import reactor.core.publisher.Mono;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.AllowedActions;
import ru.yandex.mail.cerberus.client.dto.AllowedTypeActions;
import ru.yandex.mail.cerberus.client.dto.Grant;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import java.util.Set;

import static io.micronaut.http.HttpStatus.NO_CONTENT;
import static ru.yandex.mail.cerberus.client.Headers.X_CONSISTENCY_TARGET;

public interface GrantOperations {
    @Post("/user")
    @Status(NO_CONTENT)
    Mono<Void> setUserGrant(@QueryValue @Valid Uid uid, @Body @Valid Grant grant);

    @Post("/group")
    @Status(NO_CONTENT)
    Mono<Void> setGroupGrant(@QueryValue @Valid GroupId id, @QueryValue @Valid GroupType type, @Body @Valid Grant grant);

    @Post("/role")
    @Status(NO_CONTENT)
    Mono<Void> setRoleGrant(@QueryValue @Valid RoleId id, @Body @Valid Grant grant);

    @Post("/user/resources_actions")
    @Cacheable(cacheNames = "grants-cache", parameters = {"uid", "resources"})
    Mono<AllowedActions> actions(@QueryValue @Valid Uid uid,
                                 @Body @NotEmpty Set<ResourceKey> resources,
                                 @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);

    @Post("/user/single_type_resources_actions")
    @Cacheable(cacheNames = "grants-cache", parameters = {"uid", "resourceType", "resources"})
    Mono<AllowedActions> actions(@QueryValue @Valid Uid uid,
                                 @QueryValue("resource_type") @Valid ResourceTypeName resourceType,
                                 @Body @NotEmpty Set<ResourceId> resources,
                                 @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);

    @Get("/user/resource_types_actions")
    Mono<AllowedTypeActions> typesActions(@QueryValue @Valid Uid uid,
                                          @QueryValue @NotEmpty Set<ResourceTypeName> types,
                                          @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);
}
