package ru.yandex.mail.cerberus.client.ops;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.Status;
import reactor.core.publisher.Mono;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.micronaut.common.RawJsonString;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.Group;
import ru.yandex.mail.cerberus.client.dto.GroupData;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Positive;

import static io.micronaut.http.HttpStatus.ACCEPTED;
import static io.micronaut.http.HttpStatus.CREATED;
import static io.micronaut.http.HttpStatus.NO_CONTENT;
import static ru.yandex.mail.cerberus.client.Headers.X_CONSISTENCY_TARGET;

public interface GroupOperations {
    @Post("/add")
    @Status(ACCEPTED)
    Mono<Group<RawJsonString>> addGroup(@Body @Valid Group<RawJsonString> group);

    @Post("/create")
    @Status(CREATED)
    Mono<Group<RawJsonString>> createGroup(@Body @Valid GroupData<RawJsonString> data);

    @Post("/update")
    @Status(NO_CONTENT)
    Mono<Void> updateGroup(@Body @Valid Group<RawJsonString> group);

    @Delete
    @Status(NO_CONTENT)
    Mono<Void> deleteGroup(@QueryValue @Nullable Boolean strict,
                           @QueryValue @Valid GroupId id,
                           @QueryValue @Valid GroupType type);

    @Get("/all")
    Mono<Page<GroupKey, Group<RawJsonString>>> allGroups(@QueryValue("page_size") @Positive int pageSize,
                                                         @QueryValue("page_id") @Nullable @Valid GroupKey pageId,
                                                         @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);

    @Get("/filter")
    Mono<Page<GroupId, Group<RawJsonString>>> findGroupsByType(@QueryValue @Valid GroupType type,
                                                               @QueryValue("page_size") @Positive int pageSize,
                                                               @QueryValue("page_id") @Nullable @Valid GroupId pageId,
                                                               @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);

    @Post("/add_user")
    @Status(NO_CONTENT)
    Mono<Void> addUserToGroup(@QueryValue @Valid GroupId id, @QueryValue @Valid GroupType type,
                              @QueryValue @Valid Uid uid);

    @Post("/remove_user")
    @Status(NO_CONTENT)
    Mono<Void> removeUserFromGroup(@QueryValue @Valid GroupId id, @QueryValue @Valid GroupType type,
                                   @QueryValue @Valid Uid uid);
}
