package ru.yandex.mail.cerberus.client.ops;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.Status;
import reactor.core.publisher.Mono;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.LocationType;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.cerberus.client.dto.Location;
import ru.yandex.mail.micronaut.common.RawJsonString;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Positive;

import static io.micronaut.http.HttpStatus.CREATED;
import static io.micronaut.http.HttpStatus.NO_CONTENT;
import static ru.yandex.mail.cerberus.client.Headers.X_CONSISTENCY_TARGET;

public interface LocationOperations {
    @Post("/create")
    @Status(CREATED)
    Mono<Location<RawJsonString>> createLocation(@Body @Valid Location<RawJsonString> location);

    @Post("/update")
    @Status(NO_CONTENT)
    Mono<Void> updateLocation(@Body @Valid Location<RawJsonString> location);

    @Delete
    @Status(NO_CONTENT)
    Mono<Void> deleteLocation(@QueryValue @Nullable Boolean strict,
                              @QueryValue @Valid LocationId id,
                              @QueryValue @Valid LocationType type);

    @Get("/all")
    Mono<Page<LocationKey, Location<RawJsonString>>> allLocations(@QueryValue("page_size") @Positive int pageSize,
                                                                  @QueryValue("page_id") @Nullable @Valid LocationKey pageId,
                                                                  @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);

    @Get("/filter")
    Mono<Page<LocationId, Location<RawJsonString>>> findLocationsByType(@QueryValue @Valid LocationType type,
                                                                        @QueryValue("page_size") @Positive int pageSize,
                                                                        @QueryValue("page_id") @Nullable @Valid LocationId pageId,
                                                                        @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);
}
