package ru.yandex.mail.cerberus.client.ops;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.Status;
import reactor.core.publisher.Mono;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.Role;
import ru.yandex.mail.cerberus.client.dto.RoleData;

import javax.annotation.Nullable;
import javax.validation.Valid;

import static io.micronaut.http.HttpStatus.CREATED;
import static io.micronaut.http.HttpStatus.NO_CONTENT;

public interface RoleOperations {
    @Status(CREATED)
    @Post("/create")
    Mono<Role> createRole(@Body @Valid RoleData data);

    @Post("/update")
    @Status(NO_CONTENT)
    Mono<Void> updateRole(@Body @Valid Role role);

    @Delete
    @Status(NO_CONTENT)
    Mono<Void> deleteRole(@QueryValue @Nullable Boolean strict,
                          @QueryValue @Valid RoleId id);

    @Post("/assign/user")
    @Status(NO_CONTENT)
    Mono<Void> assignRoleToUser(@QueryValue @Valid RoleId id, @QueryValue @Valid Uid uid);

    @Post("/remove/user")
    @Status(NO_CONTENT)
    Mono<Void> removeRoleFromUser(@QueryValue @Valid RoleId id, @QueryValue @Valid Uid uid);

    @Post("/assign/group")
    @Status(NO_CONTENT)
    Mono<Void> assignRoleToGroup(@QueryValue @Valid RoleId id, @QueryValue("group_id") @Valid GroupId groupId,
                                 @QueryValue("group_type") @Valid GroupType groupType);

    @Post("/remove/group")
    @Status(NO_CONTENT)
    Mono<Void> removeRoleFromGroup(@QueryValue @Valid RoleId id, @QueryValue("group_id") @Valid GroupId groupId,
                                   @QueryValue("group_type") @Valid GroupType groupType);
}
