package ru.yandex.mail.cerberus.client.ops;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.Status;
import reactor.core.publisher.Mono;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.client.dto.UserWithGroups;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.UserType;
import ru.yandex.mail.cerberus.client.dto.User;
import ru.yandex.mail.micronaut.common.RawJsonString;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Positive;
import java.util.List;
import java.util.Set;

import static io.micronaut.http.HttpStatus.CREATED;
import static io.micronaut.http.HttpStatus.NO_CONTENT;
import static ru.yandex.mail.cerberus.client.Headers.X_CONSISTENCY_TARGET;

public interface UserOperations {
    @Status(CREATED)
    @Post("/create")
    Mono<Uid> addUser(@Body @Valid User<RawJsonString> user);

    @Status(CREATED)
    @Post("/create/batch")
    Mono<Set<Uid>> addUsers(@QueryValue("skip_existing") @Nullable Boolean skipExisting,
                            @Body @Valid List<User<RawJsonString>> users);

    @Post("/update")
    @Status(NO_CONTENT)
    Mono<Void> updateUser(@Body @Valid User<RawJsonString> user);

    @Delete
    @Status(NO_CONTENT)
    Mono<Void> deleteUser(@QueryValue @Nullable Boolean strict,
                          @QueryValue @Valid Uid uid);

    @Get("/filter")
    Mono<Page<Uid, User<RawJsonString>>> users(@QueryValue @Nullable UserType type,
                                               @QueryValue("page_size") @Positive int pageSize,
                                               @QueryValue("page_id") @Nullable @Valid Uid pageId,
                                               @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);

    @Get("/with_groups/filter")
    Mono<Page<Uid, UserWithGroups<RawJsonString>>> usersWithGroups(@QueryValue @Nullable UserType type,
                                                                   @QueryValue("page_size") @Positive int pageSize,
                                                                   @QueryValue("page_id") @Nullable @Valid Uid pageId,
                                                                   @Header(X_CONSISTENCY_TARGET) @Nullable ReadTarget readTarget);
}
