JUNIT5()

JDK_VERSION(11)

OWNER(
    g:calendar-back
)

INCLUDE(../../../micronaut/dependency_versions.inc)
INCLUDE(../../../micronaut/test_deps.inc)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

JAVAC_FLAGS(
    -parameters
    -Xlint:unchecked
)

JVM_ARGS(
    -Djava.net.preferIPv6Addresses=true
)

NO_LINT()
SIZE(medium)
REQUIREMENTS(network:full)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/cerberus/client/src/test/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/cerberus/client/src/test/resources **/*)

PEERDIR(
    mail/cerberus/client
    mail/java/pglocal/junit_jupiter
    contrib/java/io/micronaut/test/micronaut-test-junit5
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
    io.micronaut.annotation.processing.TypeElementVisitorProcessor
    io.micronaut.annotation.processing.PackageConfigurationInjectProcessor
    io.micronaut.annotation.processing.BeanDefinitionInjectProcessor
)

END()
