package ru.yandex.mail.cerberus.core;

import javax.annotation.Nullable;

import static java.util.Objects.requireNonNullElse;

public enum CollisionStrategy {
    SKIP_EXISTING,
    FAIL;

    public static CollisionStrategy resolve(@Nullable Boolean skipExisting) {
        if (requireNonNullElse(skipExisting, false)) {
            return SKIP_EXISTING;
        } else {
            return FAIL;
        }
    }
}
