package ru.yandex.mail.cerberus.core;

import javax.annotation.Nullable;

import static java.util.Objects.requireNonNullElse;

public enum DeletionMode {
    STRICT,
    SOFT;

    public static DeletionMode resolve(@Nullable Boolean strict) {
        if (requireNonNullElse(strict, false)) {
            return STRICT;
        } else {
            return SOFT;
        }
    }
}
