package ru.yandex.mail.cerberus.core.change_log;

import java.util.Collection;

import io.micronaut.context.annotation.DefaultImplementation;

import static ru.yandex.mail.micronaut.common.CerberusUtils.mapToList;

@DefaultImplementation(PersistentChangeLog.class)
public interface ChangeLog {
    <T> void writeCreation(T object, SubjectExtractor<T> subjectExtractor);

    <T> void writeCreation(Collection<T> objects, SubjectExtractor<T> subjectExtractor);

    <T> void writeUpdating(T oldObject, T newObject, SubjectExtractor<T> subjectExtractor);

    <T> void writeUpdating(Collection<T> oldObjects, Collection<T> newObjects, SubjectExtractor<T> subjectExtractor);

    void writeDeletion(ChangeSubject subject);

    default <T> void writeDeletion(T object, SubjectExtractor<T> subjectExtractor) {
        writeDeletion(subjectExtractor.extractSubject(object));
    }

    void writeDeletion(Collection<ChangeSubject> subjects);

    default <T> void writeDeletion(Collection<T> objects, SubjectExtractor<T> subjectExtractor) {
        writeDeletion(mapToList(objects, subjectExtractor::extractSubject));
    }
}
