package ru.yandex.mail.cerberus.core.change_log;

import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.dao.change_log.ChangeSubjectType;
import ru.yandex.mail.micronaut.common.value.LongValueType;

@Value
@AllArgsConstructor
public class LongIdSubject implements ChangeSubject {
    long id;
    ChangeSubjectType type;

    public LongIdSubject(LongValueType object, ChangeSubjectType type) {
        this(object.getValue(), type);
    }

    @Override
    public ChangeSubjectType changeType() {
        return type;
    }
}
