package ru.yandex.mail.cerberus.core.grant;

import io.micronaut.context.annotation.DefaultImplementation;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.AllowedActions;
import ru.yandex.mail.cerberus.client.dto.AllowedTypeActions;
import ru.yandex.mail.cerberus.client.dto.Grant;
import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.client.dto.ResourceType;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

@DefaultImplementation(DefaultGrantManager.class)
public interface GrantManager {
    default ReadTarget defaultReadTarget() {
        return ReadTarget.SLAVE;
    }

    CompletableFuture<Boolean> isSuperuser(Uid uid, ReadTarget readTarget);

    default CompletableFuture<Boolean> isSuperuser(Uid uid) {
        return isSuperuser(uid, ReadTarget.SLAVE);
    }

    CompletableFuture<Void> setGrant(Uid uid, Grant grant);

    CompletableFuture<Void> setGrant(GroupKey groupKey, Grant grant);

    CompletableFuture<Void> setGrant(RoleId roleId, Grant grant);

    CompletableFuture<AllowedActions> actions(Uid uid, Set<ResourceKey> keys, ReadTarget readTarget);

    default CompletableFuture<AllowedActions> actions(Uid uid, Set<ResourceKey> keys) {
        return actions(uid, keys, defaultReadTarget());
    }

    CompletableFuture<AllowedActions> actions(Uid uid, ResourceTypeName resourceType, Set<ResourceId> resources, ReadTarget readTarget);

    default CompletableFuture<AllowedActions> actions(Uid uid, ResourceTypeName resourceType, Set<ResourceId> resources) {
        return actions(uid, resourceType, resources, defaultReadTarget());
    }

    CompletableFuture<AllowedTypeActions> typesActions(Uid uid, Set<ResourceTypeName> resourceTypes, ReadTarget readTarget);

    default CompletableFuture<AllowedTypeActions> typesActions(Uid uid, Set<ResourceTypeName> resourceTypes) {
        return typesActions(uid, resourceTypes, defaultReadTarget());
    }
}
