package ru.yandex.mail.cerberus.core.group;

import io.micronaut.context.annotation.DefaultImplementation;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.core.DeletionMode;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.Group;
import ru.yandex.mail.cerberus.client.dto.GroupData;
import ru.yandex.mail.cerberus.ReadTarget;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@DefaultImplementation(DefaultGroupManager.class)
public interface GroupManager {
    default ReadTarget defaultReadTarget() {
        return ReadTarget.SLAVE;
    }

    CompletableFuture<GroupKey> findDefaultGroup();

    <T> CompletableFuture<Group<T>> insert(Group<T> group);

    <T> CompletableFuture<List<Group<T>>> insert(List<Group<T>> groups);

    <T> CompletableFuture<Group<T>> create(GroupData<T> data);

    <T> CompletableFuture<List<Group<T>>> create(List<GroupData<T>> data, Class<T> infoType);

    <T> CompletableFuture<Void> update(Collection<Group<T>> groups);

    <T> CompletableFuture<List<Group<T>>> findGroups(Class<T> infoType, GroupType type, Set<GroupId> ids, ReadTarget readTarget);

    default <T> CompletableFuture<List<Group<T>>> findGroups(Class<T> infoType, GroupType type, Set<GroupId> ids) {
        return findGroups(infoType, type, ids, defaultReadTarget());
    }

    <T> CompletableFuture<Page<GroupKey, Group<T>>> groups(Pageable<GroupKey> pageable, Class<T> infoType, ReadTarget readTarget);

    default <T> CompletableFuture<Page<GroupKey, Group<T>>> groups(Pageable<GroupKey> pageable, Class<T> infoType) {
        return groups(pageable, infoType, defaultReadTarget());
    }

    <T> CompletableFuture<Page<GroupId, Group<T>>> groups(GroupType type, Pageable<GroupId> pageable, Class<T> infoType,
                                                          ReadTarget readTarget);

    default <T> CompletableFuture<Page<GroupId, Group<T>>> groups(GroupType type, Pageable<GroupId> pageable, Class<T> infoType) {
        return groups(type, pageable, infoType, defaultReadTarget());
    }

    CompletableFuture<Void> delete(GroupKey key, DeletionMode mode);

    default <T> CompletableFuture<Void> delete(Group<T> group, DeletionMode mode) {
        return delete(group.extractKey(), mode);
    }

    void addUserSync(GroupKey groupKey, Uid uid);

    CompletableFuture<Void> addUser(GroupKey groupKey, Uid uid);

    CompletableFuture<Void> removeUser(GroupKey groupKey, Uid uid);

    void addUsersSync(GroupType groupType, Map<Uid, Set<GroupId>> groupIdsByUid);

    CompletableFuture<Void> addUsers(GroupType groupType, Map<Uid, Set<GroupId>> groupIdsByUid);

    CompletableFuture<Void> removeUsers(GroupType groupType, Map<Uid, Set<GroupId>> groupIdsByUid);
}
