package ru.yandex.mail.cerberus.core.location;

import io.micronaut.context.annotation.DefaultImplementation;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.LocationType;
import ru.yandex.mail.cerberus.core.DeletionMode;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.client.dto.Location;
import ru.yandex.mail.cerberus.client.dto.LocationData;
import ru.yandex.mail.cerberus.ReadTarget;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@DefaultImplementation(DefaultLocationManager.class)
public interface LocationManager {
    default ReadTarget defaultReadTarget() {
        return ReadTarget.SLAVE;
    }

    <T> CompletableFuture<Location<T>> create(LocationData<T> data);

    <T> CompletableFuture<List<Location<T>>> create(List<LocationData<T>> data, Class<T> infoType);

    <T> CompletableFuture<Location<T>> insert(Location<T> location);

    <T> CompletableFuture<List<Location<T>>> insert(List<Location<T>> locations);

    <T> CompletableFuture<Void> update(List<Location<T>> locations);

    CompletableFuture<Void> delete(LocationKey key, DeletionMode mode);

    <T> CompletableFuture<Page<LocationKey, Location<T>>> locations(Pageable<LocationKey> pageable, Class<T> infoClass,
                                                                    ReadTarget readTarget);

    default <T> CompletableFuture<Page<LocationKey, Location<T>>> locations(Pageable<LocationKey> pageable, Class<T> infoClass) {
        return locations(pageable, infoClass, defaultReadTarget());
    }

    <T> CompletableFuture<Page<LocationId, Location<T>>> locationsByType(LocationType type, Pageable<LocationId> pageable,
                                                                         Class<T> infoClass, ReadTarget readTarget);

    default <T> CompletableFuture<Page<LocationId, Location<T>>> locationsByType(LocationType type, Pageable<LocationId> pageable,
                                                                                 Class<T> infoClass) {
        return locationsByType(type, pageable, infoClass, defaultReadTarget());
    }

    <T> CompletableFuture<List<Location<T>>> findByType(Class<T> infoClass, LocationType type, Set<LocationId> ids,
                                                        ReadTarget readTarget);

    default <T> CompletableFuture<List<Location<T>>> findByType(Class<T> infoClass, LocationType type, Set<LocationId> ids) {
        return findByType(infoClass, type, ids, defaultReadTarget());
    }
}
